/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ui.s3.dialogs;

import com.aptana.ide.core.io.ConnectionPointType;
import com.aptana.ide.core.io.CoreIOPlugin;
import com.aptana.ide.core.io.IBaseRemoteConnectionPoint;
import com.aptana.ide.core.io.IConnectionPoint;
import com.aptana.ui.IPropertyDialog;
import com.aptana.ui.s3.S3UIPlugin;
import com.aptana.ui.s3.dialogs.Messages;
import com.aptana.ui.s3.internal.S3ConnectionPropertyComposite;
import java.text.MessageFormat;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class S3ConnectionPointPropertyDialog
extends TitleAreaDialog
implements IPropertyDialog,
S3ConnectionPropertyComposite.Listener {
    private Image titleImage;
    private S3ConnectionPropertyComposite s3Composite;
    private IBaseRemoteConnectionPoint s3ConnectionPoint;
    private boolean lockedUI;

    public S3ConnectionPointPropertyDialog(Shell parentShell) {
        super(parentShell);
        this.setHelpAvailable(false);
    }

    public boolean isResizable() {
        return true;
    }

    public void setPropertySource(Object element) {
        this.s3ConnectionPoint = null;
        if (element instanceof IBaseRemoteConnectionPoint) {
            this.s3ConnectionPoint = (IBaseRemoteConnectionPoint)element;
        }
        if (this.s3Composite != null) {
            this.s3Composite.setConnectionPoint(this.s3ConnectionPoint);
        }
    }

    public Object getPropertySource() {
        return this.s3ConnectionPoint;
    }

    protected ConnectionPointType getConnectionPointType() {
        if (this.s3ConnectionPoint != null) {
            return CoreIOPlugin.getConnectionPointManager().getType((IConnectionPoint)this.s3ConnectionPoint);
        }
        return CoreIOPlugin.getConnectionPointManager().getType("s3");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        this.titleImage = S3UIPlugin.getImageDescriptor("/icons/full/wizban/s3.png").createImage();
        dialogArea.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                S3ConnectionPointPropertyDialog.this.dispose();
            }
        });
        this.setTitleImage(this.titleImage);
        if (this.s3ConnectionPoint != null) {
            this.setTitle(MessageFormat.format(Messages.S3ConnectionPointPropertyDialog_MessageTitle_Edit, this.getConnectionPointType().getName()));
            this.getShell().setText(Messages.S3ConnectionPointPropertyDialog_Title_Edit);
        } else {
            this.setTitle(MessageFormat.format(Messages.S3ConnectionPointPropertyDialog_MessageTitle_New, this.getConnectionPointType().getName()));
            this.getShell().setText(Messages.S3ConnectionPointPropertyDialog_Title_New);
        }
        this.s3Composite = this.createConnectionComposite(dialogArea, this.s3ConnectionPoint);
        this.s3Composite.setLayoutData(GridDataFactory.fillDefaults().grab(true, true).create());
        return dialogArea;
    }

    protected S3ConnectionPropertyComposite createConnectionComposite(Composite parent, IBaseRemoteConnectionPoint connectionPoint) {
        return new S3ConnectionPropertyComposite(parent, 0, connectionPoint, this);
    }

    protected S3ConnectionPropertyComposite getConnectionComposite() {
        return this.s3Composite;
    }

    protected void dispose() {
        if (this.titleImage != null) {
            this.setTitleImage(null);
            this.titleImage.dispose();
            this.titleImage = null;
        }
    }

    protected boolean canHandleShellCloseEvent() {
        return !this.lockedUI && super.canHandleShellCloseEvent();
    }

    protected void okPressed() {
        if (!this.s3Composite.isValid()) {
            return;
        }
        if (this.s3Composite.completeConnection()) {
            this.s3ConnectionPoint = this.s3Composite.getConnectionPoint();
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        this.s3Composite.setCanceled(true);
        if (!this.lockedUI) {
            super.cancelPressed();
        }
    }

    protected Control createContents(Composite parent) {
        try {
            Control control = super.createContents(parent);
            return control;
        }
        finally {
            this.s3Composite.validate();
        }
    }

    public void setValid(boolean valid) {
        Button button = this.getButton(0);
        if (button != null) {
            button.setEnabled(valid);
        }
    }

    public void error(String message) {
        if (message == null) {
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            this.setErrorMessage(message);
        }
    }

    public void lockUI(boolean lock) {
        this.lockedUI = lock;
        this.getButton(0).setEnabled(!lock);
    }

    public void layoutShell() {
        Point size = this.getInitialSize();
        Rectangle bounds = this.getConstrainedShellBounds(new Rectangle(0, 0, size.x, size.y));
        this.getShell().setSize(bounds.width, bounds.height);
    }
}

